package ixagentwizard;

import java.awt.*;
import java.awt.event.*;
import java.io.*;

import javax.swing.*;

/**
 * <p>Title: I-X Agent Wizard</p>
 *
 * <p>Description: Tool for mamaging I-X agents/panels</p>
 *
 * <p>This class is the user GUI to the I-X Agent Wizard. </p>
 *
 * <p>Copyright: Copyright (c) 2004</p>
 *
 * <p>Company: University of Edinburgh</p>
 *
 * @author Gerhard Wickler
 * @version 1.0
 */
public class IXAgentWizardFrame extends JFrame {

	private static final long serialVersionUID = 1L;

	// the application to which this is an interface:
    protected IXAgentWizardClass application;

    // the menu bar for this frame:
    JMenuBar theMenuBar = new JMenuBar();
    JMenu fileMenu = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu helpMenu = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();

    // the top-level pane for this frame:
    JPanel contentPane;
    BorderLayout contentPaneLayout = new BorderLayout();

    // the status bar at bottom of the contentPane:
    JLabel statusBar = new JLabel();

    // the main agent config panel in the contentPane:
    JPanel agentPanel = new JPanel();
    BorderLayout agentPanelLayout = new BorderLayout();

    // the panel containing the OK/Cancel buttons; inside agentPanel:
    JPanel okCancelPanel = new JPanel();
    BorderLayout okCancelPanelLayout = new BorderLayout();
    JButton createButton = new JButton();

    // the panel containing all config components; inside agentPanel:
    JPanel agentConfigPanel = new JPanel();
    BorderLayout agentConfigPanelLayout = new BorderLayout();

    // the panel for the lhs text field labels; inside agentConfigPanel:
    JPanel agentDirLabelsPanel = new JPanel();
    GridLayout agentDirLabelsPanelLayout = new GridLayout();
    JLabel agentDirLabel = new JLabel();
    JLabel displayNameLabel = new JLabel();
    JLabel symbolNameLabel = new JLabel();
    JLabel iconPathLabel = new JLabel();
    JLabel serverLabel = new JLabel();

    // the panel for the text fields; inside agentConfigPanel:
    JPanel agentDirPathsPanel = new JPanel();
    GridLayout agentDirPathsPanelLayout = new GridLayout();
    JTextField agentDirPathTextField = new JTextField();
    JTextField displayNameTextField = new JTextField();
    JTextField symbolicNameTextField = new JTextField();
    JTextField iconPathTextField = new JTextField();
    JCheckBox serverCheckBox = new JCheckBox();

    // the panel for the rhs buttons; inside agentConfigPanel:
    JPanel agentDirButtonsPanel = new JPanel();
    GridLayout agentDirButtonsPanelLayout = new GridLayout();
    JButton agentDirButton = new JButton();
    JLabel dummyLabel1 = new JLabel();
    JLabel dummyLabel2 = new JLabel();
    JButton iconPathButton = new JButton();
    JLabel dummyLabel3 = new JLabel();

    /**
     * <p>This constructor creates and initializes the GUI frame. </p>
     */
    public IXAgentWizardFrame(IXAgentWizardClass application) {
        this.application = application;
        try {
            setDefaultCloseOperation(EXIT_ON_CLOSE);
            jbInit();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * <p>This function is called by the constructor and performs the GUI
     * component initialization. </p>
     *
     * @throws java.lang.Exception if GUI initialization fails for some reason
     */
    private void jbInit() throws Exception {
        // set up the menu entry for File|Exit:
        jMenuFileExit.setText("Exit");
        jMenuFileExit.addActionListener(
                new IXAgentWizardFrame_jMenuFileExit_ActionAdapter(this));
        // set up the File menu:
        fileMenu.setText("File");
        fileMenu.add(jMenuFileExit);
        // set up the menu entry for File|Exit:
        jMenuHelpAbout.setText("About");
        jMenuHelpAbout.addActionListener(
                new IXAgentWizardFrame_jMenuHelpAbout_ActionAdapter(this));
        // set up the Help menu:
        helpMenu.setText("Help");
        helpMenu.add(jMenuHelpAbout);
        // set up the menu bar for this frame:
        theMenuBar.add(fileMenu);
        theMenuBar.add(helpMenu);
        setJMenuBar(theMenuBar);

        // the panel for the lhs text field labels; inside agentConfigPanel:
        agentDirLabelsPanelLayout.setColumns(1);
        agentDirLabelsPanelLayout.setRows(5);
        agentDirLabelsPanel.setLayout(agentDirLabelsPanelLayout);
        agentDirLabel.setText("Agent Directory: ");
        agentDirLabelsPanel.add(agentDirLabel);
        displayNameLabel.setText("Display Name: ");
        agentDirLabelsPanel.add(displayNameLabel);
        symbolNameLabel.setText("Symbolic Name: ");
        agentDirLabelsPanel.add(symbolNameLabel);
        iconPathLabel.setText("Icon: ");
        agentDirLabelsPanel.add(iconPathLabel);
        serverLabel.setText("Name Server: ");
        agentDirLabelsPanel.add(serverLabel);

        // the panel for the text fields; inside agentConfigPanel:
        agentDirPathsPanelLayout.setColumns(1);
        agentDirPathsPanelLayout.setRows(5);
        agentDirPathsPanel.setLayout(agentDirPathsPanelLayout);
        agentDirPathTextField.setText("");
        agentDirPathsPanel.add(agentDirPathTextField);
        displayNameTextField.setText("My Agent");
        agentDirPathsPanel.add(displayNameTextField);
        symbolicNameTextField.setText("my-agent");
        agentDirPathsPanel.add(symbolicNameTextField);
        iconPathTextField.setText("");
        agentDirPathsPanel.add(iconPathTextField);
        agentDirPathsPanel.add(serverCheckBox);

        // the panel for the rhs buttons; inside agentConfigPanel:
        agentDirButtonsPanelLayout.setColumns(1);
        agentDirButtonsPanelLayout.setRows(5);
        agentDirButtonsPanel.setLayout(agentDirButtonsPanelLayout);
        agentDirButton.setText("Browse ...");
        agentDirButton.addActionListener(
                new IXAgentWizardFrame_agentDirButton_actionAdapter(this));
        agentDirButtonsPanel.add(agentDirButton);
        dummyLabel1.setText(" ");
        agentDirButtonsPanel.add(dummyLabel1);
        dummyLabel2.setText(" ");
        agentDirButtonsPanel.add(dummyLabel2);
        iconPathButton.setText("Browse ...");
        iconPathButton.addActionListener(
                new IXAgentWizardFrame_iconPathButton_actionAdapter(this));
        agentDirButtonsPanel.add(iconPathButton);
        dummyLabel3.setText(" ");
        agentDirButtonsPanel.add(dummyLabel3);

        // set up the panel containing all config components; inside agentPanel:
        agentConfigPanel.setLayout(agentConfigPanelLayout);
        agentConfigPanel.add(agentDirLabelsPanel, java.awt.BorderLayout.WEST);
        agentConfigPanel.add(agentDirPathsPanel, java.awt.BorderLayout.CENTER);
        agentConfigPanel.add(agentDirButtonsPanel, java.awt.BorderLayout.EAST);

        // set up the panel containing the OK/Cancel buttons; inside agentPanel:
        okCancelPanel.setLayout(okCancelPanelLayout);
        okCancelPanel.add(createButton, java.awt.BorderLayout.EAST);
        createButton.setText("Create Agent");
        createButton.addActionListener(
                new IXAgentWizardFrame_createButton_actionAdapter(this));

        // set up the main agent config panel in the contentPane:
        agentPanel.setLayout(agentPanelLayout);
        agentPanel.add(agentConfigPanel, java.awt.BorderLayout.NORTH);
        agentPanel.add(okCancelPanel, java.awt.BorderLayout.SOUTH);

        // set up the status bar at bottom of the contentPane:
        statusBar.setText("initializing ...");

        // set up the top-level pane for this frame:
        contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(contentPaneLayout);
        contentPane.add(agentPanel, java.awt.BorderLayout.CENTER);
        contentPane.add(statusBar, java.awt.BorderLayout.SOUTH);

        // set up this frame:
        this.setSize(new Dimension(400, 250));
        this.setTitle("I-X Agent Wizard");
    }

    /**
     * File | Exit action performed.
     *
     * @param actionEvent ActionEvent
     */
    void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    /**
     * Help | About action performed.
     *
     * @param actionEvent ActionEvent
     */
    void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        IXAgentWizardFrame_AboutBox dlg = new IXAgentWizardFrame_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = getSize();
        Point loc = getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x,
                        (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.pack();
        dlg.show();
    }

    public void agentDirButton_actionPerformed(ActionEvent e) {
        application.dirSelect.setDialogTitle("Select a directory");
        application.dirSelect.setCurrentDirectory(
                new File(agentDirPathTextField.getText()));
        if (application.dirSelect.showDialog(this, "Select") ==
            JFileChooser.APPROVE_OPTION) {
            String newPath = application.dirSelect.getSelectedFile().getPath();
            if ((new File(newPath)).canWrite()) {
                agentDirPathTextField.setText(newPath);
            } else {
                application.displayErrorMessage(
                        "Cannot write to " + newPath + '!');
            }
        }
    }

    public void iconPathButton_actionPerformed(ActionEvent e) {
        application.fileSelect.setDialogTitle("Select an icon image");
        application.fileSelect.setCurrentDirectory(
                new File(iconPathTextField.getText()));
        application.fileSelect.setFileFilter(new GIFFileFilter());
        if (application.fileSelect.showDialog(this, "Select") ==
            JFileChooser.APPROVE_OPTION) {
            String newFile = application.fileSelect.getSelectedFile().getPath();
            File f = new File(newFile);
            if ((!f.isDirectory()) && f.canRead()) {
                iconPathTextField.setText(newFile);
            } else {
                application.displayErrorMessage(
                        "Invalid icon file: " + newFile + '!');
            }
        }
    }

    public void createButton_actionPerformed(ActionEvent e) {
        // validate the agent directory:
        /*if (!(new File(agentDirPathTextField.getText())).canWrite()) {
            application.displayErrorMessage(
                    "Cannot write to " + agentDirPathTextField.getText() + '!');
            return;
        }*/
        // validate the symbolic name:
        char[] sName = symbolicNameTextField.getText().toCharArray();
        if (!Character.isLetter(sName[0])) {
            application.displayErrorMessage("Invalid symbolic agent name!");
            return;
        }
        for (int i = sName.length - 1; i > 0; i--) {
            if (!(Character.isLetterOrDigit(sName[i]) || sName[i] == '-')) {
                application.displayErrorMessage("Invalid symbolic agent name!");
                return;
            }
        }
        // validate the icon:
        File f = new File(iconPathTextField.getText());
        if (f.isDirectory() || !f.canRead()) {
            application.displayErrorMessage("Invalid icon file: " + f + '!');
            return;
        }
        // create the agent:
        application.createAgent(
                agentDirPathTextField.getText(),
                displayNameTextField.getText(),
                symbolicNameTextField.getText());
        // set the status bar:
        statusBar.setText("Agent created: " + symbolicNameTextField.getText());
    }

}


class IXAgentWizardFrame_jMenuFileExit_ActionAdapter implements ActionListener {
    IXAgentWizardFrame adaptee;

    IXAgentWizardFrame_jMenuFileExit_ActionAdapter(IXAgentWizardFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        adaptee.jMenuFileExit_actionPerformed(actionEvent);
    }
}


class IXAgentWizardFrame_jMenuHelpAbout_ActionAdapter implements ActionListener {
    IXAgentWizardFrame adaptee;

    IXAgentWizardFrame_jMenuHelpAbout_ActionAdapter(IXAgentWizardFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        adaptee.jMenuHelpAbout_actionPerformed(actionEvent);
    }
}


class IXAgentWizardFrame_agentDirButton_actionAdapter implements ActionListener {
    private IXAgentWizardFrame adaptee;

    IXAgentWizardFrame_agentDirButton_actionAdapter(IXAgentWizardFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.agentDirButton_actionPerformed(e);
    }
}


class IXAgentWizardFrame_iconPathButton_actionAdapter implements ActionListener {
    private IXAgentWizardFrame adaptee;

    IXAgentWizardFrame_iconPathButton_actionAdapter(IXAgentWizardFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.iconPathButton_actionPerformed(e);
    }
}


class IXAgentWizardFrame_createButton_actionAdapter implements ActionListener {
    private IXAgentWizardFrame adaptee;
    IXAgentWizardFrame_createButton_actionAdapter(IXAgentWizardFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.createButton_actionPerformed(e);
    }
}


class GIFFileFilter extends javax.swing.filechooser.FileFilter {
    GIFFileFilter() {
    }

    public boolean accept(File f) {
        String fName = f.getName();
        String fExtension = fName.substring(
                fName.lastIndexOf('.') + 1, fName.length()).toLowerCase();
        return fExtension.equals("gif");
    }

    public String getDescription() {
        return ("GIF Images");
    }
}
