package ixagentwizard;

import java.awt.*;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * <p>Title: I-X Agent Wizard</p>
 *
 * <p>Description: Tool for mamaging I-X agents/panels</p>
 *
 * <p>Copyright: Copyright (c) 2004</p>
 *
 * <p>Company: University of Edinburgh</p>
 *
 * @author Gerhard Wickler
 * @version 1.0
 */
public class ErrorMessageBox extends JDialog {

	private static final long serialVersionUID = 1L;
	
	JPanel mainPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel textPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    JLabel messageLabel = new JLabel();

    public ErrorMessageBox(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            setDefaultCloseOperation(DISPOSE_ON_CLOSE);
            jbInit();
            pack();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ErrorMessageBox() {
        this(new Frame(), "ErrorMessageBox", false);
    }

    public void setMessageText(String text) {
        messageLabel.setText(text);
    }

    private void jbInit() throws Exception {
        mainPanel.setLayout(borderLayout1);
        okButton.setText("OK");
        okButton.addActionListener(new ErrorMessageBox_okButton_actionAdapter(this));
        messageLabel.setText(" ");
        getContentPane().add(mainPanel);
        mainPanel.add(textPanel, java.awt.BorderLayout.CENTER);
        textPanel.add(messageLabel);
        buttonPanel.add(okButton);
        mainPanel.add(buttonPanel, java.awt.BorderLayout.SOUTH);
    }

    public void okButton_actionPerformed(ActionEvent e) {
        dispose();
    }
}


class ErrorMessageBox_okButton_actionAdapter implements ActionListener {
    private ErrorMessageBox adaptee;
    ErrorMessageBox_okButton_actionAdapter(ErrorMessageBox adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.okButton_actionPerformed(e);
    }
}
