/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Jun 17 16:29:21 2008 by Jeff Dalton
 * Copyright: (c) 2008, AIAI, University of Edinburgh
 */

package ix.util.match;

import junit.framework.*;

import java.util.*;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.*;

/** SimpleMatcher test cases */

public class SimpleMatcherTest extends TestCase {

    public SimpleMatcherTest(String name) {
	super(name);
    }

    public void testBasicCases() {

	tryMatch("12", "12", null, "()");

	tryMatch("\"apple pie\"", "\"apple pie\"", null, "()");

	tryMatch("(a b c)", "(a b c)", null, "()");

	tryMatch("(a b c)", "(a b c d)", null, null); // expect fail

	tryMatch("(?a b ?c)", "(a b c)", null, "((?a a) (?c c))");

	tryMatch("(?a b ?c)", "(a b c)", "((?a a) (?c c))", "((?a a) (?c c))");

	tryMatch("(a b &rest ?c)", "(a b c d)", null, "((?c (c d)))");

	tryMatch("(a (?b ?c) ?d)", "(a (2 3) 4)", null,
		 "((?b 2) (?c 3) (?d 4))");

    }

    public void testVarAppearingTwice() {

	tryMatch("(?a ?a)", "(apple apple)", null, "((?a apple))");

    }

    public void testOptionalRest() {

	tryMatch("(condition ?p = ?v &optional at ?end)",
		 "(condition (colour ?block) = red)",
		 null,
		 "((?p (colour ?block)) (?v red))");

	tryMatch("(condition ?p = ?v &optional at ?end)",
		 "(condition (colour ?block) = red at e/3)",
		 null,
		 "((?p (colour ?block)) (?v red) (?end e/3))");

	tryMatch("(a &optional b &optional ?c)",
		 "(a)",
		 null,
		 "()");

	tryMatch("(a &optional b &optional ?c)",
		 "(a b)",
		 null,
		 "()");

	tryMatch("(a &optional b &optional ?c)",
		 "(a b cc)",
		 null,
		 "((?c cc))");

    }

    private void tryMatch(String pat, String dat, String env, String expect) {
	MatchEnv resultEnv =
	    SimpleMatcher.match(Lisp.readFromString(pat),
				Lisp.readFromString(dat),
				makeEnv(env));
	assertEquals(makeEnv(expect), resultEnv);
	
    }

    private MatchEnv makeEnv(String alist) {
	if (alist == null)
	    return null;
	else
	return (MatchEnv)((LList)Lisp.readFromString(alist))
                             .alistToMap(new MatchEnv());
    }

}
