/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Jan 19 15:30:14 2004 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.util.lisp;

import java.util.*;

import junit.framework.*;

import ix.util.AbstractListIteratorTest;
import ix.util.Seq;


/**
 * LListIterator test cases.
 */
public class LListListIteratorTest extends AbstractListIteratorTest
implements ConvenientSymbols {

    protected LList abc;
    protected Iterator abc_i;

    public LListListIteratorTest(String name) {
	super(name);
    }

    protected Collection makeEmptyCollection() {
	return Lisp.list();	// N.B. not modifiable
    }

    protected Collection makeCollection(Collection source) {
	// Because the empty LList isn't modifiable, we can't use
	// the inherited method which makes an empty collection
	// and then calls its addAll method.
	return LList.newLList(source);
    }

    protected void setUp() {
	abc = (LList)Lisp.readFromString("(a b c)");
	abc_i = abc.listIterator();
    }

    public void testIteratorClass() {
	assertTrue(abc_i instanceof Iterator);
	assertTrue(abc_i instanceof ListIterator);
	assertTrue(abc_i instanceof LListListIterator);
    }

    public void testFirstElementRemoval() {
	// Remove isn't supported.
	// /\/: Check that exception thrown.
    }

}
