/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Jan 19 17:37:52 2004 by Jeff Dalton
 * Copyright: (c) 2001, 2004, AIAI, University of Edinburgh
 */

package ix.util.context;

import junit.framework.*;

/**
 * Simple test cases for contexts.
 */
public class BasicContextTest extends TestCase {

    public BasicContextTest(String name) {
	super(name);
    }

    protected void setUp() {
	Context.clearContexts();
    }

    protected void tearDown() {
	Context.clearContexts();
    }

    public void testNewContext() {
	Context c1 = new Context();
	assertSame(c1.getParent(), Context.rootContext);
	assertTrue(Context.rootContext.getChildren().contains(c1));
    }

    public void testSimpleContextLookup1() {
	String s1 = "s1";
	Context rt = Context.rootContext;
	Context c1 = new Context();
	ContextLink cl1 = new ContextLink(s1);
	assertSame(s1, Context.getInContext(cl1, rt));
	assertSame(s1, Context.getInContext(cl1, c1));
    }

    public void testSimpleContextLookup2() {
	String s1 = "s1";
	String s2 = "s2";
	Context rt = Context.rootContext;
	Context c1 = new Context();
	ContextLink cl1 = new ContextLink(s1);
	assertSame(s1, Context.getInContext(cl1, rt));
	assertSame(s1, Context.getInContext(cl1, c1));

	Context.setInContext(cl1, c1, s2);
	assertSame(s1, Context.getInContext(cl1, rt));
	assertSame(s2, Context.getInContext(cl1, c1));

	Context c2 = new Context();
	assertSame(s1, Context.getInContext(cl1, c2));

	String s3 = "s3";
	Context.setInContext(cl1, c2, s3);
	assertSame(s1, Context.getInContext(cl1, rt));
	assertSame(s2, Context.getInContext(cl1, c1));
	assertSame(s3, Context.getInContext(cl1, c2));

    }

}
