/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Feb  6 23:43:19 2002 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;
import java.io.*;

import junit.framework.*;

/**
 * Useful static utilities.
 */

public class TestUtil {

    private TestUtil() { }	// block instantiation

    public static Object serializeAndBack(Object obj)
        throws java.io.IOException,
	       java.io.OptionalDataException,
	       java.lang.ClassNotFoundException {

	ByteArrayOutputStream byte_out = new ByteArrayOutputStream();
	ObjectOutputStream out = new ObjectOutputStream(byte_out);
	out.writeObject(obj);
	out.flush();

	ByteArrayInputStream byte_in
	    = new ByteArrayInputStream(byte_out.toByteArray());
	ObjectInputStream in = new ObjectInputStream(byte_in);
	return in.readObject();
    }

}
