/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Feb 16 17:25:52 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.util;

import junit.framework.*;

import java.util.*;

import ix.util.lisp.*;

/** {@link ix.util.StructuralEquality} test cases */

public class StructuralEqualityTest extends TestCase {

    public StructuralEqualityTest(String name) {
	super(name);
    }

    /*
     * Set equality tests.
     *
     * In most cases, we'll use a LinkedHashSet so that we
     * can control the iteration order.
     */

    public void testTreeSetNonEquality() {
	// This was a bug that caused a NoSuchElementException.
	StructuralEquality eq = new StructuralEquality();
	Set set1 = new TreeSet(elts("a d e"));
	Set set2 = new TreeSet(elts("b d e"));
	assertFalse(eq.equal(set1, set2));
    }

    public void testSetEquality() {
	StructuralEquality eq = new StructuralEquality();
	assertTrue(equalSets(eq, "a b c", "a b c"));
	assertTrue(equalSets(eq, "a b c", "b c a")); // bug, returned false
    }

    public void testSetNonEquality() {
	StructuralEquality eq = new StructuralEquality();
	assertFalse(equalSets(eq, "a d e", "b d e")); // NoSuchElementException
    }

    boolean equalSets(StructuralEquality eq, String s1, String s2) {
	return eq.equal(new LinkedHashSet(elts(s1)),
			new LinkedHashSet(elts(s2)));
    }

    LList elts(String s) {
	return Lisp.elementsFromString(s);
    }

}
