/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun May 23 03:01:31 2004 by Jeff Dalton
 * Copyright: (c) 1998, 2001, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

import junit.framework.*;

import ix.util.lisp.*;

/** ix.util.Strings test cases */

public class StringsTest extends TestCase {

    public StringsTest(String name) {
	super(name);
    }

    public void testBreakAt() {
	assertEquals(Lisp.list("an", "apple", "a", "day"),
		     Strings.breakAt("-", "an-apple-a-day"));
	assertEquals(Lisp.list("", "apple", ""),
		     Strings.breakAt("-", "-apple-"));
	assertEquals(Lisp.list("", ""),
		     Strings.breakAt("-", "-"));
	assertEquals(Lisp.list("", "", ""),
		     Strings.breakAt("-", "--"));
	assertEquals(Lisp.list(),
		     Strings.breakAt("-", ""));
    }

    public void testBreakAtAny() {
	assertEquals(Lisp.list("an", "apple", "a", "day"),
		     Strings.breakAtAny("-+", "an-apple+a-day"));
	assertEquals(Lisp.list("", "apple", ""),
		     Strings.breakAtAny("-", "-apple-"));
	assertEquals(Lisp.list("", ""),
		     Strings.breakAtAny("-", "-"));
	assertEquals(Lisp.list("", "", ""),
		     Strings.breakAtAny("-+", "+-"));
	assertEquals(Lisp.list(),
		     Strings.breakAtAny("-", ""));
    }

    public void testJoinWith() {
	assertEquals("an-apple-a-day",
		     Strings.joinWith("-",
				      Lisp.list("an", "apple", "a", "day")));
    }

    public void testBeforeAfter() {
	String hmt = "head--middle--tail";
	assertEquals("head", Strings.beforeFirst("--", hmt));
	assertEquals("middle--tail", Strings.afterFirst("--", hmt));
	assertEquals("head--middle", Strings.beforeLast("--", hmt));
	assertEquals("tail", Strings.afterLast("--", hmt));
    }

    public void testFullJavaToDash() {

	// Simple, dot-less cases
	assertEquals("", Strings.fullJavaNameToDashName(""));
	assertEquals("apple", Strings.fullJavaNameToDashName("Apple"));
	assertEquals("apple", Strings.fullJavaNameToDashName("apple"));
	assertEquals("apple-pie", Strings.fullJavaNameToDashName("ApplePie"));
	assertEquals("apple-pie", Strings.fullJavaNameToDashName("applePie"));

	// Dotted cases
	assertEquals("pack.apple-pie",
		     Strings.fullJavaNameToDashName("pack.ApplePie"));
//  	assertEquals("pack.apple-pie$slice",
//  		     Strings.fullJavaNameToDashName("pack.ApplePie$Slice"));

    }

    public void testDashToFullJava() {

	// Simple, dot-less cases.
	assertEquals("", Strings.dashNameToFullJavaName(""));
	assertEquals("Apple", Strings.dashNameToFullJavaName("apple"));
	assertEquals("ApplePie", Strings.dashNameToFullJavaName("apple-pie"));

	// Dotted cases
	assertEquals("pack.ApplePie",
		     Strings.dashNameToFullJavaName("pack.apple-pie"));
//  	assertEquals("pack.ApplePie$Slice",
//  		     Strings.dashNameToFullJavaName("pack.apple-pie$slice"));

    }

}
