/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Jan 19 15:42:04 2004 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

import junit.framework.*;

import ix.util.lisp.Lisp;

/**
 * Iterator test cases.  Tests for particular iterators can subclass
 * this class in order to have all of the tests here apply to their
 * iterator.  ListIterator test classes may also directly or indirectly
 * subclass this one.  They can define the getIterator method to return
 * the ListIterator as the iterator to test.
 */
public abstract class AbstractIteratorTest extends TestCase 
implements UsefulTestObjects {

    public AbstractIteratorTest(String name) {
	super(name);
    }

    protected abstract Collection makeEmptyCollection();

    protected Collection makeCollection(Collection source) {
	// Because the empty LList isn't modifiable, we can't use
	// the inherited method which makes an empty collection
	// and then calls its addAll method.
	Collection c = makeEmptyCollection();
	c.addAll(source);
	return c;
    }

    /**
     * Returns an Iterator that's an instance of the class to be tested.
     * Use this instead of calling the collection's <tt>iterator()</tt>
     * method.  A subclass may want this method to call the collection's
     * <tt>listIterator()</tt> method instead.
     */
    protected Iterator getIterator(Collection c) {
	return c.iterator();
    }

    public void testEmptyIterator () {
	Iterator i = getIterator(makeEmptyCollection());
	assertTrue(!i.hasNext());
	try {
	    i.next();
	    fail("Should have thrown NoSuchElementException");
	}
	catch (NoSuchElementException e) {
	}
    }

    public void testSimgletonIterator() {
	Iterator i = getIterator(makeCollection(Lisp.list(STR_A)));
	assertTrue(i.hasNext());
	assertSame(STR_A, i.next());
	assertFalse(i.hasNext());
    }

}
