/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Feb 18 20:17:40 2006 by Jeff Dalton
 * Copyright: (c) 2005, 2006, AIAI, University of Edinburgh
 */

package ix.iscript;

import java.io.IOException;
import java.util.*;

import junit.framework.*;

import ix.util.*;
import ix.util.lisp.*;

public class IScriptInterpreterTest extends TestCase {

    public IScriptInterpreterTest(String name) {
	super(name);
    }

    public void testIScriptInterpreterTests() throws IOException {
	// Re-run the LispInterpreter tests but translate the code
	// to the external form before evaluating it with an
	// IScriptInterpreter.
	new LispTest().testLispInterpreterTests();
    }

    class LispTest extends LispInterpreterTest {

	LispTest() {
	    super("LispInterpreterTest for IScriptInterpreter test");
	}

	protected LispInterpreter makeLispInterpreter() {
	    return new TestInterpreter();
	}

    }

    class TestInterpreter extends LispInterpreter {

	IScriptInterpreter iscript = new IScriptInterpreter();

	TestInterpreter() {
	}

	public Object topLevelEval(Object form) {
	    if (iscript == null) // still initializing?
		return super.topLevelEval(form);
	    else {
		Debug.noteln("Translating", form);
		Interpreter.Expr internalForm = parseForm(form);
		Expression expr = internalForm.externalForm();
		return iscript.topLevelEval(expr);
	    }
	}

    }

}
