(refinement wsp-setup (web-service-problem)
  (variables ?list ?audiences ?peaks ?reaches ?shares)
  (constraints
    (world-state condition (type ?list) = top_ten_list)
    (world-state condition (type ?audiences) = average_audiences)
    (world-state condition (type ?peaks) = peak_audiences)
    (world-state condition (type ?reaches) = audience_reaches)
    (world-state condition (type ?shares) = audience_shares)))

(refinement top_ten_lister (top_ten_lister ?stats ?values to ?list)
  (variables ?stats ?values ?list)
  (constraints
    (world-state condition (type ?stats) = viewing_statistics)
    (world-state condition (type ?values) = average_audiences)
    (world-state effect (type ?list) = top_ten_list))
  (annotations
    (input-objects = ((?stats viewing_statistics) (?values average_audiences)))
    (output-objects = ((?list top_ten_list)))))

(refinement audience_averager (audience_averager ?stats to ?audiences)
  (variables ?stats ?audiences)
  (constraints
    (world-state condition (type ?stats) = viewing_statistics)
    (world-state effect (type ?audiences) = average_audiences))
  (annotations
    (input-objects = ((?stats viewing_statistics)))
    (output-objects = ((?audiences average_audiences)))))

(refinement peak_finder (peak_finder ?stats to ?peaks)
  (variables ?stats ?peaks)
  (constraints
    (world-state condition (type ?stats) = viewing_statistics)
    (world-state effect (type ?peaks) = peak_audiences))
  (annotations
    (input-objects = ((?stats viewing_statistics)))
    (output-objects = ((?peaks peak_audiences)))))

(refinement reach_finder (reach_finder ?stats to ?reaches)
  (variables ?stats ?reaches)
  (constraints
    (world-state condition (type ?stats) = viewing_statistics)
    (world-state effect (type ?reaches) = audience_reaches))
  (annotations
    (input-objects = ((?stats viewing_statistics)))
    (output-objects = ((?reaches audience_reaches)))))

(refinement share_finder (share_finder ?stats to ?shares)
  (variables ?stats ?shares)
  (constraints
    (world-state condition (type ?stats) = viewing_statistics)
    (world-state effect (type ?shares) = audience_shares))
  (annotations
    (input-objects = ((?stats viewing_statistics)))
    (output-objects = ((?shares audience_shares)))))

