(refinement wsp-setup (web-service-problem)
  (constraints
    (world-state condition (in_hospital downed_pilot_1) = true)))

(refinement hospital_lookup (hospital_lookup to ?hospital)
  (variables ?hospital ?hospital_list)
  (nodes
    (1 (list_suitable_hospitals to ?hospital_list))
    (2 (select_hospital ?hospital_list to ?hospital)))
  (orderings (1 2))
  (constraints
    (world-state effect (type ?hospital) = hospital)))

(refinement list_suitable_hospitals (list_suitable_hospitals to ?list)
  (variables ?list)
  (constraints
    (world-state effect (type ?list) = list_of_hospitals))
  (annotations
    (output-objects = ((?list list_of_hospitals)))))

(refinement select_hospital (select_hospital ?list to ?hospital)
  (variables ?list ?hospital)
  (constraints
    (world-state condition (type ?list) = list_of_hospitals)
    (world-state effect (type ?hospital) = hospital))
  (annotations
    (input-objects = ((?list list_of_hospitals)))
    (output-objects = ((?hospital hospital)))))

(refinement sar_lookup (sar_lookup ?hospital to ?sar_resource)
  (variables ?hospital ?sar_resource)
  (constraints
    (world-state condition (type ?hospital) = hospital)
    (world-state effect (type ?sar_resource) = sar_resource))
  (annotations
    (input-objects = ((?hospital hospital)))
    (output-objects = ((?sar_resource sar_resource)))))

(refinement hospital_notifier (hospital_notifier ?hospital to)
  (variables ?hospital)
  (constraints
    (world-state condition (type ?hospital) = hospital)
    (world-state effect (notified_hospital ?hospital) = true))
  (annotations
    (input-objects = ((?hospital hospital)))))

(refinement resource_notifier (resource_notifier ?resource to)
  (variables ?resource)
  (constraints
    (world-state condition (type ?resource) = sar_resource)
    (world-state effect (notified_resource ?resource) = true))
  (annotations
    (input-objects = ((?resource sar_resource)))))

(refinement rescue_controller (rescue_controller ?hospital
                                  ?sar_resource ?pilot to)
  (variables ?hospital ?sar_resource ?pilot)
  (nodes
    (1 (hospital_lookup to ?hospital))
    (2 (sar_lookup ?hospital to ?sar_resource))
    (3 (hospital_notifier ?hospital to))
    (4 (resource_notifier ?sar_resource to)))
  (orderings
    (1 2 3) (2 4))
  (constraints
    ;;; Remove conditions now handled by the subplan introduced above.
    ;; (world-state condition (type ?hospital) = hospital)
    ;; (world-state condition (type ?sar_resource) = sar_resource)
    ;; (world-state condition (type ?pilot) = pilot)
    ;; (world-state condition (notified_hospital ?hospital) = true)
    ;; (world-state condition (notified_resource ?sar_resource) = true)
    (world-state effect (location ?pilot) = ?hospital)
    (world-state effect (in_hospital ?pilot) = true)))

