
;;; Cities in vertical slices taken W -> E:

(defun cities()
  '(Milwaukee Chicago Indianapolis
    Detroit Toledo Columbus Cincinnati Lexington Atlanta
    Cleveland
    Toronto Buffalo Pittsburgh Charleston Charlotte
    Syracuse Scranton Baltimore Washington Richmond Raleigh
    Montreal Burlington Albany New_York Philadelphia
    Boston))

(defun connection-list ()
  ;; Connections listed are those towards the (logical) NE .. S
'((line Milwaukee Chicago)
  (line Chicago Toledo) 
  (line Chicago Indianapolis)
  (line Indianapolis Columbus)
  (line Indianapolis Cincinnati)
  (line Indianapolis Lexington)
  (line Detroit Toronto)
  (line Detroit Toledo)
  (line Toledo Cleveland)
  (line Toledo Columbus)
  (line Columbus Pittsburgh)
  (line Columbus Cincinnati)
  (line Cincinnati Charleston)
  (line Cincinnati Lexington)
  (line Lexington Atlanta)
  (line Atlanta Charlotte)
  (line Cleveland Buffalo)
  (line Toronto Montreal)
  (line Toronto Buffalo)
  (line Buffalo Syracuse)
  (line Buffalo Pittsburgh)
  (line Pittsburgh Scranton)
  (line Pittsburgh Charleston)
  (line Charleston Richmond)
  (line Charleston Charlotte)
  (line Charlotte Raleigh)
  (line Syracuse Albany)
  (line Syracuse Scranton)
  (line Scranton New_York)
  (line Scranton Philadelphia)
  (line Scranton Baltimore)
  (line Baltimore Philadelphia)
  (line Baltimore Washington)
  (line Washington Richmond)
  (line Richmond Raleigh)
  ; Raleigh
  (line Montreal Burlington)
  (line Burlington Albany)
  (line Albany Boston)
  (line Albany New_York)
  ; New_York
  (line Philadelphia New_York)
  ; Boston
))

(define *connections* (make-hash-map))

; (defmacro line (from to)
;   `(progn
;      (nconcf-new (connections ',from) ',to)
;      (nconcf-new (connections ',to  ) ',from)))

(defun old-process-connections (lines)
  (for-each process-connection lines)
  ;; Since we can't modify a map as we iterator over its entries,
  ;; we build a new map instead.
  (let ((new-map (make-hash-map)))
    (for-each-entry (lambda (city set)
		      (put new-map city (make-list set)))
		    *connections*)
    (setq *connections* new-map)))

(defun process-connections (lines)
  (for-each process-connection lines))

(defun process-connection (c)
  (let ((line (elt c 0))
	(from (elt c 1))
	(to (elt c 2)))
    (if (eq line 'line)
	(progn
	  (record-connection from to)
	  (record-connection to from))
      (error "Invalid connection: " c))))

(defun record-connection (from to)
  (let ((set (get *connections* from nil)))
    (cond ((eq set nil)
	   (setq set (make-collection 'set '()))
	   (put *connections* from set)))
    (add set to)))

(process-connections (connection-list))

(defun connections (from)
  (or (get *connections* from FALSE)
      (error from " is not a known city.")))

(defun is-directly-connected (from to)
  (let ((by-from (contains (connections from) to))
	(by-to (contains (connections to) from)))
    (if (and by-from by-to)
	TRUE
      (if (or by-from by-to)
	  (error from " and " to " are not connected both ways.")
	FALSE))))

(defun connected-cities (from)
  (connections from))

(defun already-visited (train place)
  (let ((pattern (list 'visited train place)))
    (not (eq (get-world-state-value pattern) :undef))))

(defun path-steps (path)
  ;; E.g. from path (a b c d) to steps ((a b) (b c) (c d)).
  (if (null (rest path))
      '()
    (let ((a (elt path 0))
	  (b (elt path 1)))
      (cons (list a b) (path-steps (rest path))))))

;; Hide connect actions in psgraphs.
; (defun-for-domain psgraph-hidden-actions ()
;   '(connect))
