;;; Tests that durations affect the available of effects
;;; Author: Jeff Dalton
;;; Updated: Fri Jun 29 13:19:32 2007 by Jeff Dalton

(annotations
  (achievable-world-state-conditions = :none))

(refinement test1 (test1) ; no solutions
  (nodes
    (1 (provide green))
    (2 (require green)))
  (constraints
    (temporal duration self = PT5M .. PT5M)))

(refinement test2 (test2) ; one solution, because more time is available
  (nodes
    (1 (provide green))
    (2 (require green)))
  (constraints
    (temporal duration self = PT6M .. PT6M)))

(refinement test3 (test3) ; one solution with (colour) = red at end
  (nodes
    (0 (take 2 minutes before))
    (1 (provide red))
    (2 (provide green))
    (3 (take 2 minutes after)))
  (orderings
    (0 1) (2 3)) ; force the red effect to be after the green
  (constraints
    (temporal duration self = PT5M .. PT5M)))

(refinement test4 (test4) ; one solution
  (nodes
    (1 (test3))
    (2 (require red)))
  (orderings
    (1 2)))

(refinement test5 (test5) ; no solutions
  (nodes
    (1 (test3))
    (2 (require green)))
  (orderings
    (1 2)))

(refinement provide-colour (provide ?colour)
  (variables ?colour)
  (constraints
    (world-state effect (colour) = ?colour)
    (temporal duration self = PT3M .. PT3M)))

(refinement require-colour (require ?colour)
  (variables ?colour)
  (constraints
    (world-state condition (colour) = ?colour)
    (temporal duration self = PT3M .. PT3M)))

(refinement take-2-minutes (take 2 minutes ?whatever)
  (variables ?whatever) ; just to tell different activities apart
  (constraints
    (temporal duration self = PT2M .. PT2M)))

;;; End
