;;; Simple SC resource tests
;;; Author: Jeff Dalton
;;; Updated: Tue Apr 24 17:10:02 2007 by Jeff Dalton

;;; This is a simple solution-counting test of simple strictly-consumable
;;; resource constraints.  The orderings keep the number of solutions
;;; down to small, easily understood numbers.

(refinement test1 (test1)
  ;; 3 solutions, consuming 0, 1, or 2 apples.
  (nodes
    (1 (consume)))
  (constraints
    (resource overall (apples) = 2)))

(refinement consume-nothing (consume))

(refinement consume-1-and-recurse (consume)
  (nodes
    (1 (consume)))
  (constraints
    (resource consume (apples) = 1)))

(refinement test2 (test2)
  ;; 3 solutions, consuming 0, 1, or 2 apples under node 1,
  ;; always with 0 under node 2.
  (nodes
    (1 (secondary-limit 2))
    (2 (consume)))
  (orderings
    (1 2))
  (constraints
    (resource overall (apples) = 2)))

(refinement secondary-limit (secondary-limit ?n)
  (variables ?n)
  (nodes
    (1 (consume)))
  (constraints
    (resource overall (apples) = ?n)))

(refinement test3 (test3)
  ;; 4 solutions, consuming 0 or 1 apples under node 1
  ;; with either 0 or 1 under node 2.
  (nodes
    (1 (secondary-limit 1))
    (2 (consume)))
  (orderings
    (1 2))
  (constraints
    (resource overall (apples) = 2)))

;;; End
