;;; Simple tests of consume-the-only constraints.
;;; Author: Jeff Dalton
;;; Updated: Tue May 27 23:05:41 2008 by Jeff Dalton
;;; Copyright: (c) 2008, AIAI, University of Edinburgh

;;; Test1 has 5 solutions, consuming A B, A, nothing, B A, and B
;;; respectively.

(refinement test1 (test1)
  (nodes
    (1 (repeat something))))

(refinement repeat (repeat something)
  (nodes
    (1 (consume ?something))
    (2 (repeat something)))
  (orderings
    (1 2)))

(refinement end-repeat (repeat something))

(refinement do (consume ?something)
  (constraints
    (compute multiple-answer (identity (A B)) = ?something)
    (resource consume-the-only (?something) = true)))

;;; Test2 has two solutions, one consuming B, and one with no
;;; consume activity.

(refinement test2 (test2)
  (nodes
    (1 (repeat something)))
  (constraints
    (resource consume-the-only (A) = true)))

;;; End
