;;; Extremely simple tests
;;; Author: Jeff Dalton
;;; Updated: Tue Jun 17 16:55:12 2008 by Jeff Dalton
;;; Copyright: (c) 2008, AIAI, University of Edinburgh

;;; Test 1 -- since there is only one possible result from the
;;; compute conditions, the durations can be filled in when
;;; the refinement is instantiated and never become Variables.

(refinement test1 (test1)
  (variables ?min ?max)
  (constraints
    (compute (* 2 60 60 1000) = ?min)	; 2 hours
    (compute (* 3 60 60 1000) = ?max)	; 3 hours
    (temporal duration self = ?min .. ?max)))

;;; Test 2 -- since there are two possible results from the
;;; compute conditions, the durations become Variables until
;;; one result is picked.

(refinement test2 (test2)
  (variables ?hours ?duration)
  (constraints
    (compute multiple-answer (identity (2 3)) = ?hours) ; 2 or 3 hours
    (compute (* ?hours 60 60 1000) = ?duration)
    (temporal duration self = ?duration)))

;;; End
