;;; A simple refuelling domain.
;;; Author: Jeff Dalton
;;; Updated: Thu May  8 16:46:18 2008 by Jeff Dalton
;;; Copyright: (c) 2008, AIAI, University of Edinburgh

;;; Assumes:
;;;  * refuelling is needed if a UAV has < 50 units of fuel.
;;;  * flying always takes 30 units of fuel.
;;;  * a UAV starts with 100 units
;;;  * refueling leaves a UAV with 100 units

(annotations
  (achievable-world-state-conditions = :none))

(refinement test1 (test1)
  (nodes
    (0 (setup))
    (1 (take-photo U-1 Edinburgh))
    (2 (take-photo U-1 Glasgow))
    (3 (take-photo U-1 Stirling)))
  (orderings
    (0 (1 2 3))))

(refinement test2 (test2)
  (nodes
    (0 (setup))
    (1 (take-photo U-1 Edinburgh))
    (2 (take-photo U-1 Glasgow))
    (3 (take-photo U-1 Stirling)))
  (orderings
    (0 1 2 3)))

(refinement setup (setup)
  (constraints
    (world-state effect (fuel U-1) = 100)))

(refinement fly-without-refuel (take-photo ?uav ?place)
  (variables ?uav ?place ?fuel)
  (nodes
    (1 (fly ?uav ?place)))
  (constraints
    (resource use (?uav) = true)
    (world-state condition (fuel ?uav) = ?fuel)
    (compute (>= ?fuel 50) = true)))

(refinement fly-with-refuel (take-photo ?uav ?place)
  (variables ?uav ?place ?fuel)
  (nodes
    (1 (refuel ?uav))
    (2 (fly ?uav ?place)))
  (orderings
    (1 2))
  (constraints
    (resource use (?uav) = true)
    (world-state condition (fuel ?uav) = ?fuel)
    (compute (< ?fuel 50) = true)))

(refinement fly (fly ?uav ?place)
  (variables ?uav ?place ?fuel ?remaining-fuel)
  (constraints
    (world-state condition (fuel ?uav) = ?fuel)
    (compute (- ?fuel 30) = ?remaining-fuel)
    (compute (> ?remaining-fuel 0) = true)
    (world-state effect (fuel ?uav) = ?remaining-fuel)
    (world-state effect (location ?uav) = ?place)))

(refinement refuel (refuel ?uav)
  (variables ?uav)
  (constraints
    (world-state effect (fuel ?uav) = 100)))

;;; End
