;;; Used to see how many different plans we get.

;;; This is complicated by node-ends acting semi-independently.

(annotations
  ;; Turn off the operation that instantly executes node-ends
  ;; that lack both conditions and effects without trying them
  ;; in different orders.  Otherwise, all of the tests would
  ;; have only 1 solution.
  (iplan-try-pointless-permutations = true))

(refinement test1 (test1)
  ;; Should have 1 solution.
  (nodes
    (1 (do a))))

(refinement test2 (test2)
  ;; Should have 6 solutions.
  ;; a-begin a-end b-begin b-end
  ;; a-begin b-begin a-end b-end
  ;; a-begin b-begin b-end a-end
  ;; b-begin a-begin a-end b-end
  ;; b-begin a-begin b-end a-end
  ;; b-begin b-end a-begin a-end
  (nodes
    (1 (do a))
    (2 (do b))))

(refinement test3 (test3)
  ;; Should have 90 solutions.  (That's not good news.)
  ;; Consider the 6 solutions for test2.
  ;; In each, c-begin could be in any of 5 positions
  ;; For each c-begin position, c-end could be anywhere after it.
  ;;   c-begin 1st -- 5 c-end positions
  ;;   c-begin 2nd -- 4 c-end positions
  ;;   c-begin 3rd -- 3 c-end positions
  ;;   c-begin 4th -- 2 c-end positions
  ;;   c-begin 5th -- 1 c-end position
  ;; That's a total of 5+4+3+2+1 = 15 possibilities,
  ;; and each can happen for any of the original 6 solutions,
  ;; giving a total of 6 * 15 = 90.
  (nodes
    (1 (do a))
    (2 (do b))
    (3 (do c))))
