(defun safe (m c)
  (and (safe1 m c)      ; on one bank
       (safe1 (- 3 m)   ; and the other bank
	      (- 3 c))))

(defun safe1 (m c)      ; on one bank
  (and (>= m 0)
       (>= c 0)
       (or (= m 0)
	   (>= m c))))

(defun is-state (x)                     ; roughly...
  (and (listp x) (= (length x) 5)))

(defun already-tried (state)
  (let ((pattern (list 'tried state)))
    (not (eq (get-world-state-value pattern) :undef))))

; (defun already-tried (state)
;   (print "already-tried called on " state)
;   (read-line)
;   (let ((result (real-already-tried state)))
;     (print "already-tried returned " result " for " state)
;     (read-line)
;     result))

(defun next-state (state m c)
  (apply get-next-state m c state))

(defun get-next-state (m c bank ml cl mr cr)
  ;; move m missionaries and c cannibals from the given bank to
  ;; its opposite.
  (cond ((eq bank 'left)
	 (let ((new-bank 'right)
	       (new-ml (- ml m))
	       (new-cl (- cl c))
	       (new-mr (+ mr m))
	       (new-cr (+ cr c)))
	   (if (safe new-ml new-cl)
	       (list new-bank new-ml new-cl new-mr new-cr)
	     'not-safe)))
	((eq bank 'right)
	 (let ((new-bank 'left)
	       (new-ml (+ ml m))
	       (new-cl (+ cl c))
	       (new-mr (- mr m))
	       (new-cr (- cr c)))
	   (if (safe new-ml new-cl)
	       (list new-bank new-ml new-cl new-mr new-cr)
	     'not-safe)))
	(t
	 (error "bank isn't left or right: " bank))))
