;;; Missionaries and cannibals
;;; Author: Jeff Dalton
;;; Updated: Fri Apr 27 14:50:28 2007 by Jeff Dalton

;;; This is based on the O-Plan domain mission-forward-meta.tf.
;;; Instead of using a meta-schema, though, we make "clever"
;;; use of a multiple-answer compute.

(annotations
  (compute-support-code = "test-domains/missionary-support.lsp"))

;;; Tasks

(refinement mc-problem (mc-problem)
  (nodes
    (1 (setup))
    (2 (from (left 3 3 0 0))))
  (orderings
    (1 2)))

(refinement setup (setup)
  )

;;; The empty action

(refinement finished (from (right 0 0 3 3))
  )

;;; A primitive

(refinement move (move ?state ?move)
  (variables ?state ?move)
  (constraints
    (world-state effect (tried ?state) = true)))

;;; Moving people

;;; Movements differ only in the numbers moved.

(refinement move-m-c (from ?state)
  (variables ?state ?new-state ?move)
  (nodes
    (1 (move ?state ?move))
    (2 (from ?new-state)))
  (orderings
    (1 2))
  (constraints
    (compute multiple-answer (identity ((2 0) (0 2) (1 0) (0 1) (1 1)))
	     = ?move)
    (compute (apply next-state ?state ?move) = ?new-state)
    (compute (is-state ?new-state) = true)
    (compute (already-tried ?new-state) = false)))

;;; End
