;;; House-4-no-sup: house-building without supervised conditions,
;;; but with time-limits and durations.

;;; This domain was translated from a slightly modified version
;;; of the O-Plan house-4_.tf domain, initially by a program, and
;;; then improved by hand.  The "_" part in the O-Plan domain's
;;; name means it's the late version in which formerly separate
;;; words such as "install services" were instead joined by "_"s
;;; so that the assignment of levels to action names (verbs)
;;; would not think "install services" and, say, "install drains",
;;; were instances of a general "install" action and so belonged
;;; at the same level.

;;; Effects in the refinements for the lowest-level activities,
;;; which were only_use_for_effects in the O-Plan version, became
;;; "use-for-effect" effects; and supervised and unsupervised conditions
;;; in the higher-level refinements were tuned by hand into conditions
;;; at the lower level.

;;; Note that since there are no "achieve" conditions, having
;;; "use-for-effect" instead of plain "effect" does not make any
;;; difference to what planning possibilities are considered.

(annotations (:oplan-domain = "/tmp/house-4-ish.tf"))

(refinement task-build-house (task-build-house)
  ;; 2 solutions.
  (nodes
    (0 (set-ground-condition ready))
    (1 (build-house)))
  (orderings
    (0 1)))

(refinement task-build-house-to-time-0 (task-build-house-to-time-0)
  ;; No solutions.
  (nodes
    (0 (set-ground-condition unsuitable))
    (1 (build-house)))
  (orderings
    (0 1))
  (constraints
    (temporal duration self = P0D .. P35D)))

(refinement task-build-house-to-time-1 (task-build-house-to-time-1)
  ;; 1 solution.
  (nodes
    (0 (set-ground-condition ready))
    (1 (build-house)))
  (orderings
    (0 1))
  (constraints
    (temporal duration self = P0D .. P30D)))

(refinement task-build-house-to-time-2 (task-build-house-to-time-2)
  (nodes
    (0 (set-ground-condition ready))
    (1 (build-house)))
  (orderings
    (0 1))
  ;;  time_windows  0~09:00 at begin_of 1,   ;;; start day 0 at 09:00
  ;;               35~09:00 at end_of 2;     ;;; finish by day 35 at 09:00
  (constraints
    (temporal window at b/1 = P0DT9H)
    (temporal window at e/self = P35DT9H)))

(refinement set-ground-condition (set-ground-condition ?condition)
  (variables ?condition)
  (constraints
    (world-state effect (ground-condition) = ?condition)))

(refinement build (build-house)
  (nodes (1 (excavate-and-pour-footers))
         (2 (pour-concrete-foundations))
         (3 (erect-frame-and-roof))
         (4 (lay-brickwork))
         (5 (finish-roofing-and-flashing))
         (6 (fasten-gutters-and-downspouts))
         (7 (finish-grading))
         (8 (pour-walks-and-landscape))
         (9 (install-services))
         (10 (decorate)))
  (orderings (1 2) (2 3) (3 4) (4 5) (5 6) (6 7) (7 8))
  (annotations
      (:untranslated-conditions =
          ((supervised (footers-poured) true (2 :begin)
               ((1 :end)))
           (supervised (foundations-laid) true (3 :begin)
               ((2 :end)))
           (supervised (frame-and-roof-erected) true (4 :begin)
               ((3 :end)))
           (supervised (brickwork-done) true (5 :begin)
               ((4 :end)))
           (supervised (roofing-finished) true (6 :begin)
               ((5 :end)))
           (supervised (gutters-etc-fastened) true (7 :begin)
               ((6 :end)))
           (unsupervised (storm-drains-laid) true (7 :begin))
           (supervised (grading-done) true (8 :begin)
               ((7 :end)))))))

(refinement service-1 (install-services)
  (nodes (1 (install-drains))
         (2 (lay-storm-drains))
         (3 (install-rough-plumbing))
         (4 (install-finished-plumbing))
         (5 (install-rough-wiring))
         (6 (finish-electrical-work))
         (7 (install-kitchen-equipment))
         (8 (install-air-conditioning)))
  (orderings (1 3) (3 4) (5 6) (3 7) (5 7))
  (constraints (temporal duration self = P0D .. P24D))
  (annotations
      (:untranslated-conditions =
          ((supervised (drains-installed) true (3 :begin)
               ((1 :end)))
           (supervised (rough-plumbing-installed) true (4 :begin)
               ((3 :end)))
           (supervised (rough-wiring-installed) true (6 :begin)
               ((5 :end)))
           (supervised (rough-plumbing-installed) true (7 :begin)
               ((3 :end)))
           (supervised (rough-wiring-installed) true (7 :begin)
               ((5 :end)))
           (unsupervised (foundations-laid) true (1 :begin))
           (unsupervised (foundations-laid) true (2 :begin))
           (unsupervised (frame-and-roof-erected) true (5 :begin))
           (unsupervised (frame-and-roof-erected) true (8 :begin))
           (unsupervised (basement-floor-laid) true (8 :begin))
           (unsupervised (flooring-finished) true (4 :begin))
           (unsupervised (flooring-finished) true (7 :begin))
           (unsupervised (painted) true (6 :begin))))))

(refinement decor (decorate)
  (nodes (1 (fasten-plaster-and-plaster-board))
         (2 (pour-basement-floor))
         (3 (lay-finished-flooring))
         (4 (finish-carpentry))
         (5 (sand-and-varnish-floors))
         (6 (paint)))
  (orderings (2 3) (3 4) (4 5) (1 3) (6 5))
  (constraints (temporal duration self = P0D .. P23D))
  (annotations
      (:untranslated-conditions =
          ((unsupervised (rough-plumbing-installed) true (1 :begin))
           (unsupervised (rough-wiring-installed) true (1 :begin))
           (unsupervised (air-conditioning-installed) true (1 :begin))
           (unsupervised (drains-installed) true (2 :begin))
           (unsupervised (plumbing-finished) true (6 :begin))
           (unsupervised (kitchen-equipment-installed) true (6 :begin))
           (supervised (plastering-finished) true (3 :begin)
               ((1 :end)))
           (supervised (basement-floor-laid) true (3 :begin)
               ((2 :end)))
           (supervised (flooring-finished) true (4 :begin)
               ((3 :end)))
           (supervised (carpentry-finished) true (5 :begin)
               ((4 :end)))
           (supervised (painted) true (5 :begin)
               ((6 :end)))))))

(refinement excavate-when-unsuitable (excavate-and-pour-footers)
  (constraints
    (world-state condition (ground-condition) = unsuitable)
    (world-state effect (ground-condition) = ready)
    (world-state use-for-effect (footers-poured) = true)
    (temporal duration self = P14D)))

(refinement excavate-when-ready (excavate-and-pour-footers)
  (constraints
    (world-state condition (ground-condition) = ready)
    (world-state use-for-effect (footers-poured) = true)
    (temporal duration self = P4D)))

(refinement pour-concrete (pour-concrete-foundations)
  (constraints
    (world-state use-for-effect (foundations-laid) = true)
    (world-state condition (footers-poured) = true)
    (temporal duration self = P2D)))

(refinement erect-frame (erect-frame-and-roof)
  (constraints
    (world-state use-for-effect (frame-and-roof-erected) = true)
    (world-state condition (foundations-laid) = true)
    (temporal duration self = P4D)))

(refinement brickwork (lay-brickwork)
  (constraints
    (world-state use-for-effect (brickwork-done) = true)
    (world-state condition (frame-and-roof-erected) = true)
    (temporal duration self = P7D)))

(refinement finish-roofing (finish-roofing-and-flashing)
  (constraints
    (world-state use-for-effect (roofing-finished) = true)
    (world-state condition (brickwork-done) = true)
    (temporal duration self = P3D)))

(refinement fasten-gutters (fasten-gutters-and-downspouts)
  (constraints
    (world-state use-for-effect (gutters-etc-fastened) = true)
    (world-state condition (roofing-finished) = true)
    (temporal duration self = P1D)))

(refinement finish-grading (finish-grading)
  (constraints
    (world-state use-for-effect (grading-done) = true)
    (world-state condition (gutters-etc-fastened) = true)
    (world-state condition (storm-drains-laid) = true)
    (temporal duration self = P2D)))

(refinement pour-walks (pour-walks-and-landscape)
  (constraints
    (world-state use-for-effect (landscaping-done) = true)
    (world-state condition (grading-done) = true)
    (temporal duration self = P5D)))

(refinement install-drains (install-drains)
  (constraints
    (world-state use-for-effect (drains-installed) = true)
    (world-state condition (foundations-laid) = true)
    (temporal duration self = P1D)))

(refinement lay-storm (lay-storm-drains)
  (constraints
    (world-state use-for-effect (storm-drains-laid) = true)
    (world-state condition (foundations-laid) = true)
    (temporal duration self = P1D)))

(refinement rough-plumbing (install-rough-plumbing)
  (constraints
    (world-state use-for-effect (rough-plumbing-installed) = true)
    (world-state condition (drains-installed) = true)
    (temporal duration self = P1D)))

(refinement install-finished-plumbing (install-finished-plumbing)
  (constraints
    (world-state use-for-effect (plumbing-finished) = true)
    (world-state condition (rough-plumbing-installed) = true)
    (world-state condition (flooring-finished) = true)
    (temporal duration self = P2D)))

(refinement rough-wiring (install-rough-wiring)
  (constraints
    (world-state use-for-effect (rough-wiring-installed) = true)
    (world-state condition (frame-and-roof-erected) = true)
    (temporal duration self = P2D)))

(refinement finish-electrical (finish-electrical-work)
  (constraints
    (world-state use-for-effect (electrical-work-finished) = true)
    (world-state condition (painted) = true)
    (temporal duration self = P1D)))

(refinement install-kitchen-luxury (install-kitchen-equipment)
  (constraints
    (world-state use-for-effect (kitchen-equipment-installed) = true)
    (world-state use-for-effect (installed-level-kitchen) = luxury)
    (world-state condition (flooring-finished) = true)
    (temporal duration self = P3D)))

(refinement install-kitchen-standard (install-kitchen-equipment)
  (constraints
    (world-state use-for-effect (kitchen-equipment-installed) = true)
    (world-state use-for-effect (installed-level-kitchen) = standard)
    (world-state condition (flooring-finished) = true)
    (temporal duration self = P2D)))

(refinement install-air (install-air-conditioning)
  (constraints
    (world-state use-for-effect (air-conditioning-installed) = true)
    (world-state condition (frame-and-roof-erected) = true)
    (world-state condition (basement-floor-laid) = true)
    (temporal duration self = P3D)))

(refinement fasten-plaster (fasten-plaster-and-plaster-board)
  (constraints
    (world-state use-for-effect (plastering-finished) = true)
    (world-state condition (rough-plumbing-installed) = true)
    (world-state condition (rough-wiring-installed) = true)
    (world-state condition (air-conditioning-installed) = true)
    (temporal duration self = P7D)))

(refinement pour-basement (pour-basement-floor)
  (constraints
    (world-state use-for-effect (basement-floor-laid) = true)
    (world-state condition (drains-installed) = true)
    (temporal duration self = P2D)))

(refinement lay-flooring (lay-finished-flooring)
  (constraints
    (world-state use-for-effect (flooring-finished) = true)
    (world-state condition (plastering-finished) = true)
    (world-state condition (basement-floor-laid) = true)
    (temporal duration self = P3D)))

(refinement finish-carpentry (finish-carpentry)
  (constraints
    (world-state use-for-effect (carpentry-finished) = true)
    (world-state condition (flooring-finished) = true)
    (temporal duration self = P3D)))

(refinement sand (sand-and-varnish-floors)
  (constraints
    (world-state use-for-effect (floors-finished) = true)
    (world-state condition (carpentry-finished) = true)
    (world-state condition (painted) = true)
    (temporal duration self = P2D)))

(refinement paint (paint)
  (constraints
    (world-state use-for-effect (painted) = true)
    (world-state condition (kitchen-equipment-installed) = true)
    (temporal duration self = P3D)))

;;; End
