;;; Tests that the right one of two parallel effects will prevail.
;;; Author: Jeff Dalton
;;; Updated: Fri Jun 29 03:57:50 2007 by Jeff Dalton

;;; This is essentially a version of simple-time-and-effect-tests
;;; without the duration constraints.

(annotations
  (achievable-world-state-conditions = :none))

(refinement test1 (test1) ; one solution
  (nodes
    (1 (provide-effects))
    (2 (require red)))
  (orderings
    (1 2)))

(refinement test2 (test2) ; one solution
  (nodes
    (1 (provide-effects))
    (2 (require green)))
  (orderings
    (1 2)))

(refinement provide-effects (provide-effects)
  (nodes
    (1 (provide red))
    (2 (provide green))))

(refinement test3 (test3) ; one solution
  (nodes
    (1 (provide red))
    (2 (provide green))
    (3 (require red)))
  (orderings
    ((1 2) 3)))

(refinement test4 (test4) ; one solution
  (nodes
    (1 (provide red))
    (2 (provide green))
    (3 (require green)))
  (orderings
    ((1 2) 3)))

(refinement provide-colour (provide ?colour)
  (variables ?colour)
  (constraints
    (world-state effect (colour) = ?colour)))

(refinement require-colour (require ?colour)
  (variables ?colour)
  (constraints
    (world-state condition (colour) = ?colour)))

;;; End
