;;; Using achieve

(refinement test1 (test1)
  (nodes
    (0 (setup-ca-b))
    (1 (require-abc)))
  (orderings
    (0 1)))

(refinement test2 (test2)
  (nodes
    (0 (setup-cba))
    (1 (require-abc)))
  (orderings
    (0 1)))

(refinement test3 (test3)
  (nodes
    (0 (setup-ab-c))
    (1 (require-abc)))
  (orderings
    (0 1)))

(refinement setup-ca-b (setup-ca-b)
  (annotations
    (use-for-world-state-effects = :none))
  (constraints
    (world-state effect (block a) = true)
    (world-state effect (block b) = true)
    (world-state effect (block c) = true)
    (world-state effect (cleartop c) = true)
    (world-state effect (on c a) = true)
    (world-state effect (on a table) = true)
    (world-state effect (cleartop b) = true)
    (world-state effect (on b table) = true)))

(refinement setup-ab-c (setup-ab-c)
  (annotations
    (use-for-world-state-effects = :none))
  (constraints
    (world-state effect (block a) = true)
    (world-state effect (block b) = true)
    (world-state effect (block c) = true)
    (world-state effect (cleartop a) = true)
    (world-state effect (on a b) = true)
    (world-state effect (on b table) = true)
    (world-state effect (cleartop c) = true)
    (world-state effect (on c table) = true)))

(refinement setup-cba (setup-cba)
  (annotations
    (use-for-world-state-effects = :none))
  (constraints
    (world-state effect (block a) = true)
    (world-state effect (block b) = true)
    (world-state effect (block c) = true)
    (world-state effect (cleartop c) = true)
    (world-state effect (on c b) = true)
    (world-state effect (on b a) = true)
    (world-state effect (on a table) = true)))

(refinement require-abc (require-abc)
  (constraints
    (world-state condition (on c table) = true)
    (world-state condition (on b c) = true)
    (world-state condition (on a b) = true)))

;;; Achieving block on table

(refinement table (move-to-table ?block) ; (achieve (on ?block table))
  (variables ?block ?support)
  (annotations
    (use-for-world-state-effects = (on cleartop)))
  (constraints
    (resource use (hand) = true)
    ;; See if it's on a block and so needs to be moved.
    (world-state condition (block ?block) = true)
    (world-state condition (block ?support) = true)
    (world-state condition (on ?block ?support) = true)
    ;; Its top must be clear so that it can be moved
    (world-state condition (cleartop ?block) = true)
    ;; Move the block to the table
    (world-state effect (on ?block table) = true)
    (world-state effect (on ?block ?support) = false)
    (world-state effect (cleartop ?support) = true)))

;;; Achieving block on block

(refinement move (move ?block ?to) ; (achieve (on ?block ?to))
  (variables ?block ?support ?to)
  (annotations
    (use-for-world-state-effects = (on cleartop)))
  (constraints
    (resource use (hand) = true)
    ;; Note that ?support can be the table
    (world-state condition (block ?block) = true)
    (world-state condition (block ?to) = true)
    (world-state condition (on ?block ?support) = true)
    (compute (equal ?block ?to) = false)
    (compute (equal ?support ?to) = false)
    (world-state condition (cleartop ?block) = true)
    (world-state condition (cleartop ?to) = true)
    ;; Move the block
    (world-state effect (on ?block ?to) = true)
    (world-state effect (on ?block ?support) = false)
    (world-state effect (cleartop ?to) = false)
    (world-state effect (cleartop ?support) = true)))

;;; End
