;;; Tests what happens when a node brought in to achieve one
;;; condition breaks another.

(refinement test1 (test1)
  ;; This gets only one plan.
  (variables ?something)
  (nodes
    (1 (setup))
    ;; (bake ?something) should be introduced to achieve
    ;; condition (is-baked ?food) = true but will break
    ;; the (status ?food) = ready that was true initially.
    ;; A finish-baking will have to be introduced to
    ;; restore (status ?food) = ready
    (2 (eat-baked ?something)))
  (orderings
    (1 2)))

;;; Now we start to put in more of the nodes rather than make them
;;; have to be introduced to achieve, and we list the nodes in
;;; different orders.  All of these get many plans.  The first
;;; one is nice; the later ones have more than one finish-baking
;;; or other less nice things.

(refinement test2 (test2)
  (variables ?something)
  (nodes
    (1 (setup))
    (2 (eat-baked ?something))
    (3 (finish-baking ?something)))
  (orderings
    (1 (2 3))))

(refinement test3 (test3)
  (variables ?something)
  (nodes
    (1 (setup))
    (2 (finish-baking ?something))
    (3 (eat-baked ?something)))
  (orderings
    (1 (2 3))))

(refinement test4 (test4)
  (variables ?something)
  (nodes
    (1 (setup))
    (2 (eat-baked ?something))
    (3 (bake ?something))
    (4 (finish-baking ?something)))
  (orderings
    (1 (2 3 4))))

(refinement test5 (test5)
  (variables ?something)
  (nodes
    (1 (setup))
    (2 (bake ?something))
    (3 (finish-baking ?something))
    (4 (eat-baked ?something)))
  (orderings
    (1 (2 3 4))))

(refinement setup (setup)
  (constraints
    ;; The apple starts as ready: it could be eaten as-is.
    (world-state effect (status apple) = ready))
  (annotations
    ;; Keep this refinement from being used to achieve a condition.
    (use-for-world-state-effects = :none)))

(refinement eat (eat-baked ?food)
  ;; Requires a baked and ready food.
  (variables ?food)
  (constraints
    (world-state condition (status ?food) = ready)
    (world-state condition (is-baked ?food) = true)
    (world-state effect (ate ?food) = true)))

(refinement baker (bake ?food)
  ;; Starts baking something, leaving it unready.
  (variables ?food)
  (constraints
    (world-state condition (status ?food) = ready)
    (world-state effect (is-baked ?food) = true)
    (world-state effect (status ?food) = baking)))

(refinement baking-helper (finish-baking ?food)
  ;; Finishes baking; the food is then ready.
  (variables ?food)
  (constraints
    (world-state condition (status ?food) = baking)
    (world-state effect (status ?food) = ready)))

;;; End
