/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu May 22 00:27:52 2003 by Jeff Dalton
 * Copyright: (c) 2002, 2003, AIAI, University of Edinburgh
 */

package ix.util.xml;

import javax.swing.*;
import java.awt.BorderLayout;

import java.util.*;

import ix.util.*;

/**
 * A panel that contains a simplified XML tree-editor suitable
 * for viewing objects without changing them.
 */

public class XMLTreeViewPanel extends XMLTreeEditPanel {

    public XMLTreeViewPanel() {
	super();

	// Remove everything added to the panel by super().
	removeAll();

	// Scroll panes and borders
        JScrollPane docScroll = new JScrollPane(docTree);
	docScroll.setBorder
	    (BorderFactory.createTitledBorder("Document"));

	JScrollPane textScroll = new JScrollPane(editText);
	textScroll.setBorder
	    (BorderFactory.createTitledBorder("Text"));

	// Split pane for document above text
	JSplitPane split2 = new JSplitPane
	    (JSplitPane.VERTICAL_SPLIT, docScroll, textScroll);
	split2.setDividerSize(3);
	split2.setResizeWeight(0.90);

	// Panel contents
        add(split2, BorderLayout.CENTER);

    }

    public void addTemplates() {
	// No templates.
    }

    JPopupMenu makeNodePopupMenu(EditorTree tree, TNode node) {
	return new ViewerNodePopupMenu(tree, node);
    }

    class ViewerNodePopupMenu extends NodePopupMenu {
	ViewerNodePopupMenu(EditorTree tree, TNode node) {
	    super(tree, node);
	    // /\/: The following doesn't work in addMenuItems,
	    // because the relevant "this" for calling getEditFrame()
	    // seems to be null.
	    add(makeMenuItem("Copy Subtree", existsVisibleEditor()));
	}
	void addMenuItems() {
	    add(makeMenuItem("Fully Expand", !node.isLeaf()));
	    add(makeMenuItem("Fully Collapse", !node.isLeaf()));
	}
	boolean existsVisibleEditor() {
	    Set frames = getEditFrame().getFrameGroup().memberSet();
	    for (Iterator i = frames.iterator(); i.hasNext();) {
		XMLTreeEditFrame f = (XMLTreeEditFrame)i.next();
		if (f.isVisible() && f.isEditor())
		    return true;
	    }
	    return false;
	}

    }

}
