/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Apr 16 18:05:45 2008 by Jeff Dalton
 * Copyright: (c) 2002, 2003, 2008, AIAI, University of Edinburgh
 */

package ix.util.xml;

import ix.util.*;

/**
 * Thrown to indicate a problem converting to or from XML.
 */
public class XMLException extends RuntimeException {

    /**
     * Constructs an exception contaning the specified message.
     */
    public XMLException(String message) {
	super(message);
    }

    /**
     * Constructs an exception with a description of the reason
     * as its message.
     *
     * @see Debug#describeException(Throwable)
     */
    public XMLException(Throwable reason) {
	super(Debug.describeException(reason), reason);
    }

    /**
     * Constructs an exception with a message containing the specified
     * message followed by " because " followed by a description of the
     * reason exception.
     *
     * @see Debug#describeException(Throwable)
     */
    public XMLException(String message, Throwable reason) {
	super(message + " because " + Debug.describeException(reason),
	      reason);
    }

}
