/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Sep 14 18:01:53 2004 by Jeff Dalton
 * Copyright: (c) 2002, 2004, AIAI, University of Edinburgh
 */

package ix.util.xml;

import java.io.File;
import java.util.*;

import ix.util.*;

/**
 * A FileFilter for {@link FileSyntax}es.  The filter accepts only
 * the file types handled by a specified {@link FileSyntax} or else
 * all of the types handled by any of the syntaxes that can deal
 * with objects of a specified class.
 */
public class SyntaxFileFilter extends javax.swing.filechooser.FileFilter {

    protected String description;
    protected Collection extensions;

    public SyntaxFileFilter(Class objectClass, Collection extensions) {
	String className = Strings.capitalize(XML.nameForClass(objectClass));
	this.description = className + " files";
	this.extensions = extensions;
    }

    public SyntaxFileFilter(FileSyntax syntax) {
	this.description = syntax.getFileTypeDescription()
	                   + " " + syntax.getFileTypes();
	this.extensions = syntax.getFileTypes();
    }

    public String getDescription() { return description; }

    public boolean accept(File f) {
	if (f.isDirectory())
	    return true;	// allow the user to visit subdirectories.
	String name = f.getName();
	String type = Strings.afterLast(".", name);
	return type != name	// they're != if there was a "."
	    && extensions.contains(type.toLowerCase());
    }

}
