/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Mar 13 03:44:13 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.util.reflect;

import java.util.*;

import ix.util.xml.LiteralDocument;

/**
 * Provides methods for the principal {@link ClassDescr} cases
 * when transforming an instance of the corresponding class.
 *
 * @see ClassDescr#mapObject(Object, ObjectMapper)
 * @see ObjectVisitor
 */
public interface ObjectMapper {

    // The class is one returned by instance.getClass() and so cannot
    // be an interface.

    public Object mapPrimitive(Object obj, ClassDescr cd);

    public Object mapList(List list, ClassDescr cd);

    public Object mapSet(Set set, ClassDescr cd);

    public Object mapMap(Map map, ClassDescr cd);

    public Object mapStruct(Object struct, ClassDescr cd);

    public Object mapXML(LiteralDocument xml, ClassDescr cd);

}

// Issues:
// * Unlike in ClassVistor, the List, Set, and Map cases do not
//   pass the element, key, or value classes, because they would
//   usually be ignored and can be obtained from the ClassDescr
//   if they're wanted.
