/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Mar 12 00:13:53 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.util.reflect;

/**
 * Provides methods for the principal {@link ClassDescr} cases
 * when examining a {@link ClassDescr}.
 *
 * @see ClassDescr#visitClass(ClassVisitor)
 */
public interface ClassVisitor {

    public void visitInterface(ClassDescr cd);

    public void visitPrimitive(ClassDescr cd);

    public void visitList(ClassDescr cd,
			  ClassDescr elementType);

    public void visitSet(ClassDescr cd,
			 ClassDescr elementType);

    public void visitMap(ClassDescr cd,
			 ClassDescr keyType,
			 ClassDescr ValType);

    public void visitStruct(ClassDescr cd);

    public void visitXML(ClassDescr cd);

}
