/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Sep 28 14:37:05 2008 by Jeff Dalton
 * Copyright: (c) 2008, AIAI, University of Edinburgh
 */

package ix.util.reflect;

import java.lang.annotation.*;

/**
 * Annotation that marks a field as the main "body" of the object.
 * Its primary use is to suggest how the field should be translated
 * into notations such as XML.  Typically the other fields would
 * have to be expressed as attributes, and the body would have to
 * be a list or set.
 *
 * @see ix.util.xml.CompactXMLTranslator
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@Inherited
@Documented
public @interface Body {
}
