/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Dec  7 17:05:21 2007 by Jeff Dalton
 * Copyright: (c) 2005, 2007, AIAI, University of Edinburgh
 */

package ix.util.lisp;

import ix.util.*;

/**
 * A safe interpreter for a simple dialect of Lisp.  "Safe" here
 * means that the interpreter doesn't allow user code to do such
 * things as call arbitrary Java methods, read or write files,
 * or get other information about the host machine.  Interpreters
 * are unsafe by default.  Safety is implemented by leaving out
 * built-in functions that perform unsafe operations.  It is
 * up to the implementor of an {@link Interpreter.JFunction}
 * to indicate that it is unsafe by defining it's <code>isSafe()</code>
 * method to return <i>false</i>.
 *
 * @see Interpreter#isSafe()
 * @see Interpreter#acceptOnlySafeBuiltins
 * @see LispInterpreter#LispInterpreter(boolean beSafe)
 */
public class SafeLispInterpreter extends LispInterpreter {

    public SafeLispInterpreter() {
	super(true);
    }

    public static void main(String[] argv) {
	Debug.off();
	Parameters.processCommandLineArguments(argv);
	LispInterpreter lin = new SafeLispInterpreter();
	lin.loadLisp(Parameters.getList("load-lisp"));
	lin.readEvalPrintLoop();
    }

}
