/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Apr 13 06:00:28 2005 by Jeff Dalton
 */

package ix.util.lisp;

import java.util.*;
import ix.util.*;


/** The class of {@link Lisp#NIL}, and of nothing else. */

public final class Null extends LList /* implements SemiPrimitive */ {

    Null() {				// package visibility
	Debug.expect(Lisp.NIL == null);	// only one can be made
    }

    private static NullEnumeration enumeration = new NullEnumeration();

    public boolean isNull() { return true; }

    public Object car() { return Lisp.NIL; }
    public LList cdr() { return Lisp.NIL; }

    public int length() { return 0; }

    public Object elementAt(int i) { return Lisp.NIL; }

    public Enumeration elements() { return enumeration; }

    public boolean equal(LList l) { return l == Lisp.NIL; }
    public boolean find(Object a) { return false; }

    public LList append(LList tail) { return tail; }

    protected Object readResolve() throws java.io.ObjectStreamException {
	// Deserialization magic to avoid multiple (visible)
	// instances of Null.  The instances are created (it seems)
	// but then this method is called ...
	return Lisp.NIL;
    }

    public int compareTo(Object o) {
	if (o instanceof Null)
	    return 0;
	else
	    throw new ClassCastException
		("Cannot compare a Null to " + o);
    }

    // public String toString() { return "()"; }

    public String toString() { return "nil"; }

    public static Null valueOf(String name) {
	if (name.equals("nil") || name.equals("()"))
	    return Lisp.NIL;
	else
	    throw new IllegalArgumentException
		("Improper name for NIL: " + Util.quote(name));
    }

}


/** Null enumerations. */

final class NullEnumeration extends LListEnumeration implements Enumeration {

    public boolean hasMoreElements() { return false; }

    public Object nextElement() { return Lisp.NIL; } // return null?

}
