/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Mar 22 04:48:25 2005 by Jeff Dalton
 */

package ix.util.lisp;

import java.io.*;

// /\/: Does not handle strings that extend over more than one line
//      unless the newline sequence is escaped.
// /\/: Single quote was allowed in symbols but now isn't.

// The StreamTokenizer class stinks.  There's no way to specify code
// that takes over scanning when specified chars are seen, so you're
// stuck with a very restrictive framework.  Strings can't go across
// lines.  Numbers all become Doubles.  You can't just tell it not to
// parse numbers, because paserNumbers has no argument, and the default
// is to parse them.  So the only way to have it not parse numbers
// is to call resetSyntax; and then you have to specify everything
// yourself.  The following calls are used to set things back to
// soemthing like what they would have been if resetSyntax had not
// been called (see the documentation for the StreamTokenizer(
// InputStream) constructor):
//
//    wordChars('A', 'Z');
//    wordChars('a', 'z');
//    wordChars('\u00A0', '\u00FF');
//    whitespaceChars('\u0000', '\u0020');
//
// We also call wordChars('0', '9') and make '.' a word char so that
// numbers will be parsed as words.  We can then convert them to 
// appropriate numeric objects later.

public class LispStreamTokenizer extends LispTokenizer {

    protected String specialWordChars = "!@$%^&*-_=+~:<>{}/?.";

    public LispStreamTokenizer(InputStream is) {
	super(is);
	init();
    }

    public LispStreamTokenizer(Reader r) {
	super(r);
	init();
    }

    public void setSpecialWordChars(String chars) {
	specialWordChars = chars;
    }

    private void init() {
	resetSyntax();
	// Lisp punctuation (not really needed after resetSyntax)
        ordinaryChar('(');
        ordinaryChar(')');
	// Words
	{
	    String wchars = specialWordChars;
	    char wc;
	    for (int i = 0; i < wchars.length(); i++) {
		wc = wchars.charAt(i);
		wordChars(wc, wc);
	    }
	    wordChars('A', 'Z');
	    wordChars('a', 'z');
	    wordChars('\u00A0', '\u00FF');
	    wordChars('0', '9');
	}
	// Whitespace
	whitespaceChars('\u0000', '\u0020');
	// comments
        commentChar(';');
	// String quote
        quoteChar('"');
	// Symbol quote
	quoteChar('|');
	// Settings
	eolIsSignificant(false);
	// lowerCaseMode(true);
	lowerCaseMode(false);
        // parseNumbers();
    }

}
