/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Mar  2 16:18:39 2006 by Jeff Dalton
 * Copyright: (c) 2001 - 2006, AIAI, University of Edinburgh
 */

package ix.util.ipc;

import java.util.*;
import java.io.*;
import java.net.*;

import ix.icore.IXAgent;
import ix.icore.Sendable;

import ix.util.*;
import ix.util.xml.*;
import ix.util.lisp.*;

/**
 * Standalone name-server for "simple" and "xml" communication strategies.
 */
public class SimpleNameServer {

    private static boolean _isStandAlone = false;

    public SimpleNameServer() {
    }

    public static synchronized boolean isStandAlone() {
	return _isStandAlone;
    }

    public static synchronized void setIsStandAlone(boolean v) {
	_isStandAlone = v;
    }

    public static void main(String[] argv) {
	Util.printGreeting("Name-Server");
	setIsStandAlone(true);			// global /\/
	new MiniAgent().mainStartup(argv);
    }

    static class MiniAgent extends IXAgent {

	public MiniAgent() { }

	protected void processCommandLineArguments() {
	    Parameters.setParameter("run-name-server", "true");
	    super.processCommandLineArguments();
	}

    }

}
