/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Sep 21 21:29:16 2004 by Jeff Dalton
 * Copyright: (c) 2001 - 2003, AIAI, University of Edinburgh
 */

package ix.util.ipc;

import java.io.Serializable;

import ix.util.*;
import ix.util.lisp.Lisp;
import ix.util.xml.XML;

/**
 * An object that contains a host name and a port number.
 */
public class ServiceAddress implements Serializable {

    public String host;
    public int port;

    public ServiceAddress() {}

    public ServiceAddress(String host, int port) {
	this.host = host;
	this.port = port;
    }

    /** Makes a ServiceAddress from a host:port string. */
    public ServiceAddress(String addr) {
	String[] parts = Strings.breakAtFirst(":", addr);
	if (parts[0].equals("") || parts[1].equals(""))
	    throw new IllegalArgumentException
		("service address \"" + addr + "\" -- syntax is host:port.");
	this.host = parts[0];
	Object p = Lisp.readFromString(parts[1]);
	if (p instanceof Long)
	    this.port = ((Long)p).intValue();
	else
	    throw new IllegalArgumentException
		("service address \"" + addr + "\" -- syntax is host:port, " +
		 " and port must be a positive integer.");
    }

    static { XML.addImport("ix.util.ipc.ServiceAddress"); }

    public String getHost() { return host; }
    public void setHost(String host) { this.host = host; }

    public int getPort() { return port; }
    public void setPort(int port) { this.port = port; }

    public String toString() { return "addr[" + host + ":" + port + "]"; }

}

// Issues:
// * The 0-arg constructor and the set-methods are just for XMLTranslator.
