/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Apr 23 16:17:14 2008 by Jeff Dalton
 * Copyright: (c) 2001, 2008, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

/**
 * A simple, synchronized object that contains a Context.
 */
public class SynchronizedContextHolder implements ContextHolder {

    protected Context context;

    public SynchronizedContextHolder() {
	this(Context.rootContext);
    }

    public SynchronizedContextHolder(Context c) {
	this.context = c;
    }

    public synchronized Context getContext() {
	return context;
    }

    public synchronized void setContext(Context c) {
	context = c;
    }

}
