/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun May 27 00:26:34 2001 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

import ix.util.Debug;

/**
 * A "final" version of BasicContextHolder. 
 */
public final class PlainContextHolder extends BasicContextHolder {

    public PlainContextHolder() {
	this(Context.rootContext);
    }

    public PlainContextHolder(Context c) {
	this.context = c;
    }

    public final Context getContext() {
	return context;
    }

    public final void setContext(Context c) {
	context = c;
    }

}
