/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Jan 19 18:18:13 2004 by Jeff Dalton
 * Copyright: (c) 2001, 2004, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

/**
 * A context-holding stategy that provides a single, global context-holder.
 */
public class GlobalHoldingStrategy extends ContextHoldingStrategy {

    ContextHolder globalContextHolder = new BasicContextHolder();

    public ContextHolder getContextHolder() {
	return globalContextHolder;
    }

    public void clearContexts() {
	globalContextHolder.setContext(Context.rootContext);
    }

}
