/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon May 11 16:30:27 2009 by Jeff Dalton
 * Copyright: (c) 2004, 2009, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

import ix.icore.AbstractAnnotatedObject;
import ix.icore.Annotations;

import ix.util.*;

/**
 * Provides context-dependent annotations.
 */
public abstract class ContextAnnotatedObject extends AbstractAnnotatedObject {

    // /\/: Note that there is still an 'annotations' field.

    private ContextHashMap __annMap = null; // not serialized? /\/

    public ContextAnnotatedObject() { }

    @Override
    protected Map annMap() {
        return __annMap;
    }

    @Override
    protected void makeAnnMap() {
        Debug.expect(annotations == null);
	Debug.expect(__annMap == null);
	__annMap = new ContextHashMap();
    }

    @Override
    public void setAnnotations(Annotations annotes) {
        if (annotes == null) {
            this.annotations = null;
            __annMap = null;
        }
        else {
            if (annMap() == null)
                makeAnnMap();
            takeAnnotations(annotes);
        }
    }

    public void clearAnnotationsCompletely() {
	if (__annMap != null)
	    __annMap.clearCompletely();
    }

}
