/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Nov 24 13:36:40 2007 by Jeff Dalton
 * Copyright: (c) 2000, 2004, 2005, 2007, AIAI, University of Edinburgh
 */

package ix.util;

import java.io.*;
import java.util.*;

/**
 * An unchecked exception used to wrap other Throwables when they're
 * rethrown.  Usually the wrapped Throwable is a checked exception
 * that should not or could not be handled locally.
 */
public class RethrownException extends RuntimeException {

    /**
     * Constructs an exception with a description of the cause
     * as its message.
     *
     * @see Debug#describeException(Throwable)
     */
    public RethrownException(Throwable cause) {
	this(cause, Debug.describeException(cause));
    }

    /**
     * Constructs an exception with the specified cause and message.
     * The message should be a description of the problem that does
     * not require a separate look at the cause exception.
     */
    public RethrownException(Throwable cause, String message) {
	super(message, cause);
    }

    /**
     * Constructs an exception with the specified cause and a message
     * formed by concatenating the prefix, followed by a space, to the
     * result of calling {@link Debug#describeException(Throwable)}
     * on the cause.
     */
    public RethrownException(String messagePrefix, Throwable cause) {
	this(cause, messagePrefix + " " + Debug.describeException(cause));
    }

}
