/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri May 30 17:38:07 2008 by Jeff Dalton
 * Copyright: (c) 2008, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

/**
 * A modifiable reference to an object.
 */
public class Ref<T> {

    private T item;

    public Ref() {
	this(null);
    }

    public Ref(T item) {
	this.item = item;
    }

    public T get() {
	return item;
    }

    public void set(T item) {
	this.item = item;
    }

    public String toString() {
	return "Ref[" + item + "]";
    }

}
