/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri Aug  8 19:41:03 2008 by Jeff Dalton
 * Copyright: (c) 2003, 2008, AIAI, University of Edinburgh
 */

package ix.util;

import ix.util.lisp.*;

/**
 * A simple framework for conversion in both directions between
 * {@link LList} and String representations of pattern "sentences".
 */
public abstract class PatternParser {

    /** Used by the static methods in the PatternParser class. */
    protected static Parser defaultParser = new LispPatternParser();

    public static LList parse(String pattern) {
	return defaultParser.parsePattern(pattern);
    }

    public static String unparse(LList pattern) {
	return defaultParser.unparsePattern(pattern);
    }

    public static interface Parser {
	public abstract LList parsePattern(String pattern);
	public abstract String unparsePattern(LList pattern);
    }

    /**
     * A parser that uses a Lisp-like syntax.
     *
     * @see Lisp#elementsFromString(String)
     * @see Lisp#elementsToString(Object)
     */
    public static class LispPatternParser implements Parser {

	public LispPatternParser() {
	}

	public LList parsePattern(String pattern) {
	    return Lisp.elementsFromString(pattern);
	}

	public String unparsePattern(LList pattern) {
	    if (pattern == null)
		return "";
	    else
		return Lisp.elementsToString(pattern);
	}

    }

}

