/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Aug 18 17:02:00 2008 by Jeff Dalton
 * Copyright: (c) 2008, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

/**
 * Holds long min and max values.
 */
public class MinMax {

    private long min;
    private long max;

    public MinMax(long min, long max) {
        this.min = min;
        this.max = max;
        checkRange();
    }

    /**
     * Parses a string of the form "min<b>..</b>max".
     */
    public MinMax(String spec) {
        List<String> parts = Strings.breakAt("..", spec);
        if (parts.size() != 2)
            throw new IllegalArgumentException
                ("Invalid MinMax spec: " + spec);
        this.min = Long.valueOf(parts.get(0));
        this.max = Long.valueOf(parts.get(1));
        checkRange();
    }

    private void checkRange() {
        if (min > max)
            throw new ConsistencyException
                ("Min " + min + " is not <= max " + max);
    }

    public long getMin() {
        return min;
    }

    public long getMax() {
        return max;
    }

    public String toString() {
	return "MinMax[" + min + ".." + max + "]";
    }

}
