/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Aug 16 19:39:44 2003 by Jeff Dalton
 */

package ix.util;

import java.lang.reflect.*;
import java.util.*;

/**
 * Static util methods for {@link TypedList}s.
 */
public class ListOf {

    private ListOf() { }	// block instantiation

    public static Class elementClass(List l) {
	if (l instanceof TypedList)
	    return (Class)fieldValue(l, "_elementClass");
	else
	    return Object.class;
    }

    // /\/: All of the "intface" arguments could be either an
    // interface or an implementation class.

    public static Class elementClass(Class intface) {
	return (Class)staticFieldValue(intface, "_elementClass");
    }

    public static void checkElements(Collection c, Class eltClass) {
	for (Iterator i = c.iterator(); i.hasNext();) {
	    Object elt = i.next();
	    if (!(eltClass.isInstance(elt)))
		throw new ClassCastException
		    ("Element is not of class " + eltClass.getName());
	}
    }

    public static Class[] implementationClasses(Class intface) {
	return (Class[])staticFieldValue(intface, "_implementations");
    }

    public static LinkedList makeLinkedImplementation(Class intface) {
	Class impl = findImplementationClass(intface, LinkedList.class);
	return (LinkedList)Util.makeInstance(impl);
    }

    public static ArrayList makeArrayImplementation(Class intface) {
	Class impl = findImplementationClass(intface, ArrayList.class);
	return (ArrayList)Util.makeInstance(impl);
    }

    public static Class findImplementationClass(Class intface,
						Class superclass) {
	Class[] impls = implementationClasses(intface);
	for (int i = 0; i < impls.length; i++) {
	    if (superclass.isAssignableFrom(impls[i]))
		return impls[i];
	}
	return null;
    }

    private static Object fieldValue(Object obj, String fieldName) {
	try {
	    Field f = obj.getClass().getField(fieldName);
	    return f.get(obj);
	}
	catch (NoSuchFieldException e) {
	    throw new RethrownException(e);
	}
	catch (IllegalAccessException e) {
	    throw new RethrownException(e);
	}
    }

    private static Object staticFieldValue(Class c, String fieldName) {
	try {
	    Field f = c.getField(fieldName);
	    return f.get(null);
	}
	catch (NoSuchFieldException e) {
	    throw new RethrownException(e);
	}
	catch (IllegalAccessException e) {
	    throw new RethrownException(e);
	}
    }

}
