/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun May 23 03:29:12 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.util;

import java.net.*;
import java.util.*;

import ix.util.xml.*;
import ix.util.lisp.*;

/**
 * Maps both ways between short names, in lower-case, and long names.
 */
public class LCNameMapper extends NameMapper {

    public LCNameMapper() {
    }

    public String plausibleShortName(String longName) {
	String candidate = super.plausibleShortName(longName);
	if (Strings.isAllLowerCase(candidate))
	    return candidate;
	else {
	    // The name may have "-" or "_" as a spearator
	    // as well as using case differences.
	    List parts = Strings.breakAtAny("-_", candidate);
	    for (ListIterator i = parts.listIterator(); i.hasNext();) {
		String part = (String)i.next();
		if (!Strings.isAllLowerCase(part)) {
		    i.set(Strings.javaNameToDashName(part));
		}
	    }
	    String rejoined = Strings.joinWith("-", parts);
	    // Even after conversion to a dash name, some UC chars may remain.
	    return Strings.isAllLowerCase(rejoined)
		? rejoined :
		rejoined.toLowerCase();
	}
    }

}
