/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Sep 22 16:56:37 2002 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.util;

import java.text.*;
import java.util.*;

/**
 * Converts between Dates and ISO 8601 strings.
 */
public class ISODateFormat {

    final String dateTimePattern = "yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'";

    final SimpleDateFormat format = new SimpleDateFormat(dateTimePattern);
    {
	format.setTimeZone(TimeZone.getTimeZone("GMT"));
	format.setLenient(false);
    }

    public ISODateFormat() {
    }

    public String formatDateTime(Date date) {
	return format.format(date);
    }

    public Date parseDateTime(String iso) {
	try {
	    return format.parse(iso);
	}
	catch (ParseException e) {
	    Debug.noteException(e);
	    throw new IllegalArgumentException
		("Invalid ISO 8601 date-time string: " + Strings.quote(iso));
	}
    }

}
