/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Jun 18 17:11:55 2008 by Jeff Dalton
 * Copyright: (c) 1998 - 2002, 2008, AIAI, University of Edinburgh
 */

package ix.util;

/**
 * Thrown when a consistency check detects a problem.
 */
public class ConsistencyException extends RuntimeException {

    public ConsistencyException() {
	super();
    }

    public ConsistencyException(Throwable t) {
	super("Unexpectd exception: " + Debug.describeException(t),
	      t);
    }

    public ConsistencyException(String message) {
	super(message);
    }

    public ConsistencyException(String message, Object culprit) {
	super(message + " " + culprit);
    }

}
