/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Jul 21 15:24:00 2009 by Jeff Dalton
 * Copyright: (c) 2003, 2004, 2006, 2009, AIAI, University of Edinburgh
 */

package ix.util;

import java.awt.Color;

import java.lang.reflect.Field;

import java.util.*;

import ix.iface.util.XColors;

/**
 * A source of "nice" colors for use in GUIs.
 */
public class ColorGenerator {

    protected Map<Object,Color> objectToColorMap = new HashMap<Object,Color>();

    public ColorGenerator() {
    }

    public Color genColor(Object obj) {
	Color c = objectToColorMap.get(obj);
	if (c == null)
	    setColor(obj, c = nextColor());
	Debug.noteln("Color for " + obj + " = " + c);
	return c;
    }

    public Color getColor(Object obj) {
	return getColor(obj, null);
    }

    public Color getColor(Object obj, Color defaultColor) {
	Color c = objectToColorMap.get(obj);
	return c == null ? defaultColor : c;
    }

    public void setColor(Object obj, Color color) {
	objectToColorMap.put(obj, color);
    }

    public void setColor(Object obj, int rgb) {
	setColor(obj, new Color(rgb));
    }

    public void setColor(Object obj, String colorName) {
	setColor(obj, getNamedColor(colorName));
    }

    public static Color getNamedColor(String name) {
	try {
	    Field f = XColors.class.getField(Strings.capitalize(name));
	    return (Color)f.get(null);
	}
	catch (NoSuchFieldException e) {
	    throw new IllegalArgumentException
		("Cannot find a color named " + Strings.quote(name));
	}
	catch (Exception e) {
	    throw new RethrownException(e);
	}
    }

    public Color nextColor() {
	return new Color(nextRGB());
    }

    public int nextRGB() {
	if (niceColorsUsed >= niceColors.length) {
	    Debug.noteln("Out of nice colors in " + this); // was Debug.warn
	    // return 0xFF0000; 	// Red
            return 0x000000;		// Black
	}
	return niceColors[niceColorsUsed++];
    }

    protected int niceColorsUsed = 0;
    protected int[] niceColors = {
	// The repeated order is roughly blue, green, red, yellow/brown.
	// There's an implicit blue for the home namespace at the start.
//  	0x009933,		// near forrest green
	0x228B22,		// X's ForestGreen
	0x8B0000,		// X's DarkRed
	0xB8860B,		// X's DarkGoldenRod
	0x8A2BE2,		// X's BlueViolet
	0x008B8B,		// X's DarkCyan
  	0xff6666,		// a pink
	0xA0522D,		// X's Sienna
	0x00BFFF,		// X's DeepSkyBlue
//	0x008000,		// X's Green -- too close to ForestGreen
	0x00FF7F,		// X's SpringGreen
	0xC71585,		// X's MediumVioletRed
	0x808000,		// X's Olive
	0x4682B4,		// X's SteelBlue -- too close to DarkCyan?
	0x000080,		// X's Navy
        0xa2846c,		// A light brown
	0x00CED1,		// X's DarkTurquoise
        0x800000,		// X's Maroon -- too close to DarkRed?
	0xFF4500,		// X's OrangeRed
  	0xffcc33,		// a yellow
	0x9ACD32		// X's YellowGreen
    };

}
