/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri May  9 04:06:37 2003 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.util;

import javax.swing.*;
import java.util.*;

/**
 * A thread that catches and reports errors or exceptions.
 */
public class CatchingThread extends Thread {

    Runnable innerRunnable;

    public CatchingThread() {
    }

    public CatchingThread(Runnable innerRunnable) {
	this.innerRunnable = innerRunnable;
    }

    /**
     * Calls innerRun() inside a catch that calls the
     * {@link #handleException(Throwable)} method on any
     * Throwable caught.
     */
    public void run() {
	try {
	    innerRun();
	}
	catch (Throwable except) {
	    Debug.noteException(except);
	    handleException(except);
	}
    }

    /**
     * Calls the run() method of the innerRunnable passed to the
     * constructor, if innerRunnable is non-null; otherwise does
     * nothing.  An alternative to supplying an innerRunnable
     * is to redefine this method in a subclass.
     */
    protected void innerRun() {
	if (innerRunnable != null)
	    innerRunnable.run();
	// Else nothing to do unless this method is redefined
	// by a subclass.
    }

    /**
     * Called by {@link #run()} if {@link #innerRun()} throws
     * an exception.  The method supplied by the CatchingThread
     * class calls {@link Debug#displayException(Throwable)}.
     */
    protected void handleException(final Throwable except) {
	Debug.displayException(except);
    }

}
